#!/bin/bash

HOST=$1

echo "zipping code"
cd ../../codedeploy
# remove a codedeploy.zip if you already have one.
rm -f codedeploy.zip
zip -r codedeploy.zip *
cd ..
zip -r codedeploy/codedeploy.zip ./dags ./piper
mv codedeploy/codedeploy.zip terraform/test-instance
cd terraform/test-instance
echo "scping code"
scp codedeploy.zip $HOST:/home/users/`whoami`
echo "ensuring user data has finished"
ssh -t $HOST "while [ ! -f /var/lib/cloud/instance/boot-finished ]; do echo \"waiting for user data to complete\"; sleep 5; done;"
echo "running code deploy"
ssh -t $HOST "rm -rf codedeploy/ && unzip codedeploy.zip -d codedeploy && sudo /opt/codedeploy-agent/bin/codedeploy-local -l codedeploy"
ssh -t $HOST "cat /opt/codedeploy-agent/deployment-root/default-local-deployment-group/\$(ls -t /opt/codedeploy-agent/deployment-root/default-local-deployment-group | head -1)/logs/scripts.log" > codedeploy.log
echo "saved codeploy log to codedeploy.log"
