#cloud-config
preserve_hostname: true
manage_etc_hosts: false
bootcmd:
 - cloud-init-per instance my_set_hostname sh -xc "echo "${role}-$INSTANCE_ID" | sed -e 's/-i-/-/g' > /etc/hostname; hostname -F /etc/hostname"
 - cloud-init-per instance my_etc_hosts sh -xc "sed -i -e '/^127.0.1.1/d' /etc/hosts; echo 127.0.1.1 $(cat /etc/hostname).${env}.${dns_region}.justin.tv $(cat /etc/hostname) >> /etc/hosts"
runcmd:
 - echo "twitch_environment=${environment}" > /etc/facter/facts.d/twitch_environment.txt
 - echo "twitch_role=${role}" > /etc/facter/facts.d/twitch_role.txt
 - echo "twitch_team=${owner}" > /etc/facter/facts.d/twitch_team.txt
 - echo "cluster=${cluster}" > /etc/facter/facts.d/cluster.txt
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - echo "disable_anycast=true" > /etc/facter/facts.d/disable_anycast.txt
 - echo "sandstorm_role_arn=${sandstorm_role}" > /etc/facter/facts.d/sandstorm_role_arn.txt
 - puppet agent --test --server=${puppet}
 - puppet agent --test
 - apt-get -y update
 - apt-get -y install ruby
 - apt-get -y install wget
 - cd /home/ubuntu
 - wget https://aws-codedeploy-${region}.s3.amazonaws.com/latest/install
 - chmod +x ./install
 - ./install auto
