variable "airflow_db_password" {
  default = "placeholder"
}

module "airflow" {
  source = "../lib/airflow.20170803"

  environment          = "production"
  vpc                  = "vpc-dc5a89ba"
  subnets              = "subnet-2495117f,subnet-a08d8ae9,subnet-da58b5bc"
  subnets_public       = "subnet-048c8b4d,subnet-6a901431,subnet-e95eb38f"
  security_group       = "sg-da44fea0" # twitch_subnets: allow all traffic between twitch IP space
  security_group_wpa2  = "sg-03c974f5dda13524d" # wpa2-only: allow access from WPA2 network
  db_password          = "${var.airflow_db_password}"
  db_instance_class    = "db.m4.10xlarge"
  db_allocated_storage = "1000"
  owner                = "d8a"
  account              = "twitch-service-piper-aws"
  service              = "piper-airflow"
  sandstorm_assume_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/piper-airflow-production"

  alert_arn = "${module.alerts.topic_arn}"

  airflow_certificate_arn = "arn:aws:acm:us-west-2:452744562037:certificate/d872dd0d-64ab-4cd6-9c78-709a893dc14f"
  flower_certificate_arn = "arn:aws:acm:us-west-2:452744562037:certificate/71f0379c-94f6-4a63-af89-6b0294982575"
  twvpn_certificate_arn = "arn:aws:acm:us-west-2:452744562037:certificate/a456e994-7720-4ffb-90fa-4ecc0bda2bb9"

  ami = "ami-0360e77dcdb515466"
}

module "report_bucket" {
  source = "../lib/s3-bucket.20170831"

  bucket_name = "twitch-piper-reports"

  permitted_roles = [
    "${module.airflow.master_iam_role_arn}",
    "${module.airflow.worker_iam_role_arn}",
  ]

  cors_rules = [
    {
      allowed_headers = ["Authorization"]
      allowed_methods = ["GET"]
      allowed_origins = ["https://dev.twitch.tv"]
    }
  ]
}

module "logging_bucket" {
  source = "../lib/s3-bucket.20170831"

  bucket_name = "twitch-piper-logging-production"

  permitted_roles = [
    "${module.airflow.master_iam_role_arn}",
    "${module.airflow.worker_iam_role_arn}",
  ]
}

module "extern_s3_role" {
  source = "../lib/s3-iam.20170905"

  environment = "production"

  piper_roles = [
    "${module.airflow.master_iam_role_arn}",
    "${module.airflow.worker_iam_role_arn}",
  ]
}

module "staging_bucket" {
  source = "../lib/s3-bucket.20170831"

  bucket_name = "twitch-piper-staging-aws"

  permitted_roles = [
    "${module.airflow.master_iam_role_arn}",
    "${module.airflow.worker_iam_role_arn}",
  ]
}
