variable "master_password" {
    default=""
}
variable "pagerduty_key" {}

module "alerts" {
    source = "../lib/alerting.20170713"

    environment="production"
    pagerduty_key = "${var.pagerduty_key}"
    pagerduty_service = "PLY23YP"
}

module "redshift" {
    source = "../lib/redshift.20170713"

    database="games"
    environment="production"
    node_count = 5

    vpc_group_id = "sg-da44fea0"
    subnet_ids = "subnet-6a901431,subnet-048c8b4d,subnet-e95eb38f"

    master_password = "${var.master_password}"

    project_tag = "d8a/piper"
    owner_tag = "twitch-insights-prod-alerts@amazon.com"

    public_ip = "52.27.119.240"

    alert_arn = "${module.alerts.topic_arn}"


    account_id = "452744562037"
    region = "us-west-2"
    airlow_master_role_arn = "${module.airflow.master_iam_role_arn}"
    airlow_worker_role_arn = "${module.airflow.worker_iam_role_arn}"
    bucket = "twitch-piper-staging-aws"

    roles = [
        "arn:aws:iam::452744562037:role/piper-games-redshift-s3-access",
        "arn:aws:iam::452744562037:role/piper-games-redshift-copy-unload",
    ]
}

provider "aws" {
    version = "~> 1.4"
    region = "us-west-2"
    profile = "twitch-service-piper-aws"
}

terraform {
    backend "s3" {
        bucket  = "twitch-service-piper-aws"
        key     = "tfstate/d8a/piper/terraform/production"
        region  = "us-west-2"
        profile = "twitch-service-piper-aws"
        kms_key_id = "arn:aws:kms:us-west-2:452744562037:key/d4e830f1-0ca4-4894-ad6b-856b7165751f"
    }

    required_version = "~> 0.9"
}

module "update_games_report_webhook_sns" {
    source = "../lib/webhook-sns.20190118"
    name = "games_report_update_events"
    alert_arn = "${module.alerts.topic_arn}"
    edge_iam_arn = ["arn:aws:iam::435147058744:root", "arn:aws:iam::663583029956:root"]
}

module "update_extensions_report_webhook_sns" {
    source = "../lib/webhook-sns.20190118"
    name = "extensions_report_update_events"
    alert_arn = "${module.alerts.topic_arn}"
    edge_iam_arn = ["arn:aws:iam::435147058744:root", "arn:aws:iam::663583029956:root"]
}
