variable "airflow_db_password" {
    default="placeholder"
}

module "airflow" {
    source = "../lib/airflow.20170803"

    environment = "staging"
    subnets              = "subnet-518f0b0a,subnet-bf46abd9,subnet-1380875a"
    subnets_public       = "subnet-d4880c8f,subnet-e842af8e,subnet-fe8087b7"
    security_group       = "sg-804df7fa" # twitch_subnets: allow all traffic between twitch IP space
    security_group_wpa2  = "sg-0740d965eaa6b161a" # wpa2-only: allow access from WPA2 network
    vpc = "vpc-2d57844b"
    db_password = "${var.airflow_db_password}"
    db_instance_class    = "db.m4.4xlarge"
    db_allocated_storage = "50"
    owner = "d8a"
    account = "twitch-service-piper-dev"
    service = "piper-airflow"
    sandstorm_assume_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/piper-airflow-staging"

    alert_arn = "${module.alerts.topic_arn}"

    desired_workers = 5

    airflow_certificate_arn = "arn:aws:acm:us-west-2:895328872748:certificate/255bb77c-23ed-45a2-b74b-68003f525f33"
    flower_certificate_arn = "arn:aws:acm:us-west-2:895328872748:certificate/cd9cd78a-dd31-41f9-ac0a-35b04529e5ee"
    twvpn_certificate_arn = "arn:aws:acm:us-west-2:895328872748:certificate/1bd4ff3f-c106-46b5-8b91-e0e726cd91fa"

    ami = "ami-0360e77dcdb515466"
}

module "report_bucket" {
    source = "../lib/s3-bucket.20170831"

    bucket_name="twitch-piper-reports-dev"
    permitted_roles=[
        "${module.airflow.master_iam_role_arn}",
        "${module.airflow.worker_iam_role_arn}",
        "arn:aws:iam::895328872748:role/aws-elasticbeanstalk-service-role",
        "arn:aws:iam::895328872748:role/aws-elasticbeanstalk-ec2-role"
    ]

    cors_rules = [
        {
            allowed_headers = ["Authorization"]
            allowed_methods = ["GET"]
            allowed_origins = ["dev.twitch.tv"]
        },
        {
            allowed_headers = ["Authorization"]
            allowed_methods = ["GET"]
            allowed_origins = ["*.twitch.tech"]
        },
        {
            allowed_headers = ["Authorization"]
            allowed_methods = ["GET"]
            allowed_origins = ["http://localhost:8080"]
        }
    ]
}

module "logging_bucket" {
    source = "../lib/s3-bucket.20170831"

    bucket_name="twitch-piper-logging-staging"
    permitted_roles=[
        "${module.airflow.master_iam_role_arn}",
        "${module.airflow.worker_iam_role_arn}"
    ]
}

module "extern_s3_role" {
    source = "../lib/s3-iam.20170905"

    environment="staging"
    piper_roles=[
        "${module.airflow.master_iam_role_arn}",
        "${module.airflow.worker_iam_role_arn}"
    ]
}

module "staging_bucket" {
    source = "../lib/s3-bucket.20170831"

    bucket_name = "twitch-piper-staging-dev"
    permitted_roles=[
        "${module.airflow.master_iam_role_arn}",
        "${module.airflow.worker_iam_role_arn}"
    ]
}
