variable "master_password" {
    default=""
}
variable "pagerduty_key" {}

module "alerts" {
    source = "../lib/alerting.20170713"

    environment="staging"
    pagerduty_key = "${var.pagerduty_key}"
    pagerduty_service = "PD9W637"
}

module "redshift" {
    source = "../lib/redshift.20170713"

    database="games"
    environment="staging"
    node_count = 5

    vpc_group_id = "sg-804df7fa"
    subnet_ids = "subnet-e842af8e,subnet-fe8087b7,subnet-d4880c8f"

    master_password = "${var.master_password}"

    project_tag = "d8a/piper"
    owner_tag = "twitch-insights-prod-alerts@amazon.com"

    public_ip = "34.223.211.97"

    alert_arn = "${module.alerts.topic_arn}"

    account_id = "895328872748"
    region = "us-west-2"
    airlow_master_role_arn = "${module.airflow.master_iam_role_arn}"
    airlow_worker_role_arn = "${module.airflow.worker_iam_role_arn}"
    bucket = "twitch-piper-staging-dev"

    roles = [
        "arn:aws:iam::895328872748:role/piper-games-redshift-copy-unload",
        "arn:aws:iam::895328872748:role/piper-redshift-games-s3-access"
    ]
}

provider "aws" {
    version = "~> 1.4"
    region = "us-west-2"
    profile = "twitch-service-piper-dev"
}

terraform {
    backend "s3" {
        bucket  = "twitch-service-piper-dev"
        key     = "tfstate/d8a/piper/terraform/staging"
        region  = "us-west-2"
        profile = "twitch-service-piper-dev"
        kms_key_id = "arn:aws:kms:us-east-1:895328872748:key/22908531-2b54-45f4-993b-d3f6d7be97f1"
    }

    required_version = "~> 0.9"
}

module "update_games_report_webhook_sns" {
    source = "../lib/webhook-sns.20190118"
    name = "games_report_update_events"
    alert_arn = "${module.alerts.topic_arn}"
    edge_iam_arn = ["arn:aws:iam::435147058744:root"]
}

module "update_extensions_report_webhook_sns" {
    source = "../lib/webhook-sns.20190118"
    name = "extensions_report_update_events"
    alert_arn = "${module.alerts.topic_arn}"
    edge_iam_arn = ["arn:aws:iam::435147058744:root"]
}
