#!/bin/bash

if [ -z $1 ]
then
	echo "Usage: ./test_dag.sh <dag_file_path>"
	exit 1
fi

# Use sandstorm to get the connection string for the staging airflow metadata DB.
echo "> sandstorm get insights/piper-airflow/staging/sqlalchemy"
CONN_STR=$(sandstorm get insights/piper-airflow/staging/sqlalchemy --role-arn=arn:aws:iam::734326455073:role/sandstorm/production/templated/role/piper-airflow-staging --profile twitch-web-dev)

# Run the DAG file. Nothing is being executed here, the DAG file just builds the DAG.
# If the script does not raise an exception it means that nothing is horribly wrong.
echo "> python3 $1"
PYTHONPATH=. AIRFLOW__PIPER__ENVIRONMENT=staging AIRFLOW__CORE__SQL_ALCHEMY_CONN=$CONN_STR python3 $1
