#!/bin/bash

if [ -z $1 ]
then
	echo "Usage: ./test_task.sh <dag_id> <task_id> [<date>]"
	echo "Date is in the format 2018-04-13 or 2018-04-13T00:00:00Z. Yesterday by default."
	exit 1
fi

# Read params
DAG_ID=$1  # name of dag (not the file)
TASK_ID=$2 # name of the task

if [ -z $3 ] # execution date
then
	EXECUTION_DATE=$(date -v-1d -u +"%Y-%m-%dT00:00:00Z") # yesterday UTC by default
else
	if [[ $3 =~ ^[0-9]{4}-[0-9]{2}-[0-9]{2}$ ]] # with no timezone
	then
		EXECUTION_DATE=$3T00:00:00Z # append timezone
		echo $EXECUTION_DATE
	else
		EXECUTION_DATE=$3
	fi
fi

# Use sandstorm to get the connection string for the staging airflow metadata DB.
# Other connection strings (e.g. aurora rollups db) are loaded from the metadata DB.
echo "> sandstorm get insights/piper-airflow/staging/sqlalchemy"
CONN_STR=$(sandstorm get insights/piper-airflow/staging/sqlalchemy --role-arn=arn:aws:iam::734326455073:role/sandstorm/production/templated/role/piper-airflow-staging --profile twitch-web-dev)

# Use airflow test command: https://airflow.apache.org/cli.html#test
# PYTHONPATH is needed to load modules from dags and ./piper folder. In production the piper folder is moved to plugins.
# Assume staging environment. The CONN_STR is also from staging. The airflow metadata DB contains all other DB connections.
# Use a rollbar placeholder token. If you need to use a real token you can get it with something like: sandstorm get insights/piper-airflow/staging/rollbar_token
echo "> airflow test $DAG_ID $TASK_ID $EXECUTION_DATE"
PYTHONPATH=.:dags \
AIRFLOW__PIPER__ENVIRONMENT=staging \
AIRFLOW__CORE__SQL_ALCHEMY_CONN=$CONN_STR \
AIRFLOW__PIPER__ROLLBAR_TOKEN=aaaabbbbccccddddeeeeffff00001111 \
airflow test $DAG_ID $TASK_ID $EXECUTION_DATE -sd dags
