variable "payments_account" {
  description = "payments account that assumes role in bucket account"
  default     = "arn:aws:iam::316550374861:root"
}

data "aws_iam_policy_document" "instance_assume_role_policy" {
  statement {
    actions = ["sts:AssumeRole"]

    principals {
      type        = "Service"
      identifiers = ["ec2.amazonaws.com"]
    }
  }

  statement {
    actions = ["sts:AssumeRole"]

    principals {
      type        = "AWS"
      identifiers = ["${var.payments_account}"]
    }
  }
}

resource "aws_iam_role" "payments_writer" {
  name               = "PaymentBucketWriter"
  assume_role_policy = "${data.aws_iam_policy_document.instance_assume_role_policy.json}"
}

data "aws_iam_policy_document" "payments_s3" {
  statement {
    actions = [
      "s3:ListBucket",
    ]

    effect    = "Allow"
    resources = ["${aws_s3_bucket.payments.arn}"]
  }

  statement {
    actions = [
      "s3:PutObject",
      "s3:GetObject",
      "s3:DeleteObject",
    ]

    effect    = "Allow"
    resources = ["${aws_s3_bucket.payments.arn}/*"]
  }
}

resource "aws_iam_policy" "payments_s3" {
  name        = "payments_s3"
  description = "Give role access to s3 bucket"
  policy      = "${data.aws_iam_policy_document.payments_s3.json}"
}

resource "aws_iam_role_policy_attachment" "payments_s3_attach" {
  role       = "${aws_iam_role.payments_writer.name}"
  policy_arn = "${aws_iam_policy.payments_s3.arn}"
}

output "payments_writer_role_arn" {
  value = "${aws_iam_role.payments_writer.arn}"
}
