#!/usr/bin/env node
import 'source-map-support/register';
import cdk = require('@aws-cdk/core');
import { StatsdTransformerStack } from '../lib/statsd-transformer-stack';

const app = new cdk.App();
const PRIMARY_REGION = 'us-west-2';
const STAGING_ACCOUNT_ID = '895328872748';
const PRODUCTION_ACCOUNT_ID = '452744562037';

// Add AWS environment - region, account number
const staging = {
    account: STAGING_ACCOUNT_ID,
    region: PRIMARY_REGION,
};

const production = {
    account: PRODUCTION_ACCOUNT_ID,
    region: PRIMARY_REGION,
};

const stagingPiperServiceStack = new StatsdTransformerStack(app, 'StagingStatsdTransformerStack', {
    env: staging,
});

const productionPiperServiceStack = new StatsdTransformerStack(app, 'ProductionStatsdTransformerStack', {
    env: production,
});
