import { expect as expectCDK, matchTemplate, MatchStyle } from '@aws-cdk/assert';
import cdk = require('@aws-cdk/core');
import StatsdTransformer = require('../lib/statsd-transformer-stack');

test('Empty Stack', () => {
    const app = new cdk.App();
    // WHEN
    const stack = new StatsdTransformer.StatsdTransformerStack(app, 'MyTestStack');
    // THEN
    expectCDK(stack).to(matchTemplate({
      "Resources": {}
    }, MatchStyle.EXACT))
});