package main

import (
    "swag"
    "bytes"
    "fmt"
    "io"
    "strings"
    "io/ioutil"
    "net/http"
    "encoding/base64"
    "strconv"
    // "encoding/json"
    "github.com/zenazn/goji"
//    "github.com/gorilla/schema"
)

type JiraIssue struct {
    Key string `json:"key"`
    Reporter string `json:"reporter"`
    Summary string `json:"summary"`
    Description string `json:"description"`
}

func basicAuth(username, password string) string {
  auth := username + ":" + password
   return base64.StdEncoding.EncodeToString([]byte(auth))
}

func main() {
    goji.Get("/", Root)
    goji.Get("/img/twitchswag.png", http.FileServer(http.Dir("/img")))
    goji.Post("/submit", SubmitOrder)
    goji.Serve()
}

func Root(w http.ResponseWriter, r *http.Request) {
    // In the real world you'd probably use a template or something.
    o := swag.Order{}
    o.Populate()
    html := `<html>
            <head>
            <title>Twitch Swag Order Form</title>
            <style type="text/css">
            td, body, p { font: 15px arial, sans-serif; }
            </style>
            </head>
            <body><img src="https://s3.amazonaws.com/f.cl.ly/items/0S2Z3i3a1f34162J1O1c/twitchlogo_purple.png" height=100 width=300></br>
            <h1>Holiday Order Form 2015</h1>
            <p>Each staff member is eligible for up to <u>$130</u> worth of holiday swag.  Prices and maximum orderable quantities per person are listed below.</p>
            ` + o.Display(1) + `
            </body>
            </html>`
    io.WriteString(w, html)
}                      

func SubmitOrder(w http.ResponseWriter, r *http.Request){
    url := "https://twitchtv.atlassian.net/rest/api/2/issue"
    fmt.Println("URL:>", url)

    html :=`<html>
            <head>
            <title>Thank You</title>
            <style type="text/css">
            td, body, p { font: 15px arial, sans-serif; }
            </style>
            </head>
            <body>
            `

    stafforder := swag.Order{}
    var matchfound bool
    var totalprice int = 0
    matchfound = false
    catalogue := swag.Order{}
    catalogue.Populate()    
    r.ParseForm()
    stafforder.Customer = r.FormValue("customer")
    stafforder.Location = r.FormValue("location")
    stafforder.Notes = r.FormValue("notes")
    for itemid, quantity := range r.Form {
        itemquantity := strings.Join(quantity,"")
        if itemquantity != strconv.Itoa(0) {
            for _, lineitem := range catalogue.Contents {
                SKU := strconv.Itoa(lineitem.SKU + 1)
                fmt.Printf("SKU: %v, itemid: %v, itemquantity: %v\n", SKU, itemid, itemquantity)
                if SKU == itemid{
                    lineitem.Quantity,_ = strconv.Atoi(itemquantity)
                    stafforder.Contents = append(stafforder.Contents, lineitem)
                    fmt.Println("Match found!")
                    matchfound = true
                    itemprice,err := strconv.Atoi(lineitem.Price)
                    if err != nil {
                        panic(err)
                    }
                    fmt.Printf("Item cost %v, item quantity %v, total line cost %v", itemprice, lineitem.Quantity, itemprice * lineitem.Quantity)
                    totalprice += itemprice * lineitem.Quantity
                }

            }
        }
    }

    

    if (matchfound && (totalprice <= 130) && (len(stafforder.Customer) > 0)) {
    html += fmt.Sprintf("<p>Order for %v, pick up in %v</p>\n",stafforder.Customer, stafforder.Location)
    html += stafforder.Display(2)

    html += `</body>
            </html>`

    var jsonHeader = `{"fields": {"project": { "key": "SWAG" }, "summary": "`
    var summary = "Order for " + stafforder.Customer
    var jsonMid = `", "description": "`
    var description = stafforder.Display(3)
    var jsonFooter = stafforder.Notes + `\\Location: ` + stafforder.Location + `", "issuetype": { "name": "Task" } } }`
    var jsonStr = []byte(jsonHeader + summary + jsonMid + description + jsonFooter)
    req, _ := http.NewRequest("POST", url, bytes.NewBuffer(jsonStr))
    req.Header.Set("X-Custom-Header", "myvalue")
    req.Header.Set("Content-Type", "application/json")
    req.Header.Add("Authorization","Basic "+basicAuth("autotwitch","K1tefr0ntline"))

    client := &http.Client{}
    resp, err := client.Do(req)
    if err != nil {
        panic(err)
        html += "Something went wrong, try again."
    } else {
        html += "<p>Order has been placed sucessfully, thank you.</p>"
    }
    defer resp.Body.Close()

    fmt.Println("response Status:", resp.Status)
    fmt.Println("response Headers:", resp.Header)
    body, _ := ioutil.ReadAll(resp.Body)
    fmt.Println("response Body:", string(body))

    io.WriteString(w, html)
    } else {
        if (matchfound && (len(stafforder.Customer) > 0)) {
            html += "Your order came to $" + fmt.Sprintf("%v", totalprice) + " which is over the $130 limit.<br><br>"
            html += stafforder.Display(2)
            html += "<br>You need to order less!"
            io.WriteString(w, html)
        } else {
            html += `It looks like you tried to order nothing.  Or you forgot your name.  You <i>do</i> know your name, right?</body></html>`
            io.WriteString(w, html)
        }
    }
}