package swag

import ( 
	"fmt"
//	"github.com/shopspring/decimal"
)

type Order struct {
	NumberOfItems int
    Contents []LineItem
    Customer string
    Location string
    Notes string
}

type LineItem struct {
    Quantity        int `json:"quantity"`
    Description     string `json:"description"`
    Size            string `json:"size"`
    Color           string `json:"color"`
    SKU             int `json:"sku"`
    Price           string `json:"price"`
    MaxQuantity 	int `json:"maxquantity"`
}

func (o *Order) Populate() {
o.Add(o.NumberOfItems,"Twitch Hoodie","Black","XS",3,"35")
o.Add(o.NumberOfItems,"Twitch Hoodie","Black","S",3,"35")
o.Add(o.NumberOfItems,"Twitch Hoodie","Black","M",3,"35")
o.Add(o.NumberOfItems,"Twitch Hoodie","Black","L",3,"35")
o.Add(o.NumberOfItems,"Twitch Hoodie","Black","XL",3,"35")
o.Add(o.NumberOfItems,"Twitch Hoodie","Black","2XL",3,"35")

o.Add(o.NumberOfItems,"Twitchcon Hoodie","Purple","XS",2,"50")
o.Add(o.NumberOfItems,"Twitchcon Hoodie","Purple","S",2,"50")
o.Add(o.NumberOfItems,"Twitchcon Hoodie","Purple","M",2,"50")
o.Add(o.NumberOfItems,"Twitchcon Hoodie","Purple","L",2,"50")
o.Add(o.NumberOfItems,"Twitchcon Hoodie","Purple","XL",2,"50")
o.Add(o.NumberOfItems,"Twitchcon Hoodie","Purple","2XL",2,"50")
o.Add(o.NumberOfItems,"Twitchcon Hoodie","Purple","3XL",2,"50")
o.Add(o.NumberOfItems,"Twitchcon Hoodie","Purple","4XL",2,"50")

o.Add(o.NumberOfItems,"Twitchcon Shirt (Mens)","Purple","S",5,"25")
o.Add(o.NumberOfItems,"Twitchcon Shirt (Mens)","Purple","M",5,"25")
o.Add(o.NumberOfItems,"Twitchcon Shirt (Mens)","Purple","L",5,"25")
o.Add(o.NumberOfItems,"Twitchcon Shirt (Mens)","Purple","XL",5,"25")
o.Add(o.NumberOfItems,"Twitchcon Shirt (Mens)","Purple","2XL",5,"25")
o.Add(o.NumberOfItems,"Twitchcon Shirt (Mens)","Purple","3XL",5,"25")

o.Add(o.NumberOfItems,"Twitchcon Shirt (Womens)","Purple","S",5,"25")
o.Add(o.NumberOfItems,"Twitchcon Shirt (Womens)","Purple","M",5,"25")
o.Add(o.NumberOfItems,"Twitchcon Shirt (Womens)","Purple","L",5,"25")
o.Add(o.NumberOfItems,"Twitchcon Shirt (Womens)","Purple","XL",5,"25")

o.Add(o.NumberOfItems,"Twitchcon Limited Edition Shirt (Mens)","Purple","S",5,"25")
o.Add(o.NumberOfItems,"Twitchcon Limited Edition Shirt (Mens)","Purple","M",5,"25")
o.Add(o.NumberOfItems,"Twitchcon Limited Edition Shirt (Mens)","Purple","L",5,"25")
o.Add(o.NumberOfItems,"Twitchcon Limited Edition Shirt (Mens)","Purple","XL",5,"25")
o.Add(o.NumberOfItems,"Twitchcon Limited Edition Shirt (Mens)","Purple","2XL",5,"25")
o.Add(o.NumberOfItems,"Twitchcon Limited Edition Shirt (Mens)","Purple","3XL",5,"25")

o.Add(o.NumberOfItems,"Twitchcon Limited Edition Shirt (Womens)","Purple","S",5,"25")
o.Add(o.NumberOfItems,"Twitchcon Limited Edition Shirt (Womens)","Purple","M",5,"25")
o.Add(o.NumberOfItems,"Twitchcon Limited Edition Shirt (Womens)","Purple","L",5,"25")
o.Add(o.NumberOfItems,"Twitchcon Limited Edition Shirt (Womens)","Purple","XL",5,"25")

o.Add(o.NumberOfItems,"Twitch Signature Cap","White","M/L",2,"18")
o.Add(o.NumberOfItems,"Twitch Signature Cap","White","L/XL",2,"18")
o.Add(o.NumberOfItems,"Twitch Trucker Cap","Purple/White","M/L",2,"18")

o.Add(o.NumberOfItems,"Twitch Logo Patch","Purple/White","-",10,"5")
o.Add(o.NumberOfItems,"Glitch Patch","Purple/White","-",10,"5")
o.Add(o.NumberOfItems,"Twitch Pin Blind Pack - Series 1","Purple/White","-",10,"4")
o.Add(o.NumberOfItems,"Twitch Emote Thermos","Purple/Black","-",5,"20")

/* 	XS	$35	
	M/L	$18	
Twitch White Signature Cap	L/XL	$18	
Twitch Trucker Hat		$18	
Twitch Logo Patch		$5	
Glitch Patch		$5	
Twitch Pin Blind Pack - Series 1		$4	
Twitch Emote Thermos		$20	*/
}

func (o *Order) Add(SKU int, Description string, Color string, Size string, Quantity int, Price string) {
lineitem := LineItem{}
lineitem.SKU = SKU
lineitem.Description = Description
lineitem.Color = Color
lineitem.Size = Size
lineitem.Quantity = Quantity
lineitem.Price = Price
o.Contents = append(o.Contents, lineitem) 
o.NumberOfItems++
}

func (o *Order) Display(orderform int) string {
	output := ""
	if orderform == 1 {
		output += fmt.Sprintf("<form name=\"swagorder\" method=\"POST\" action=\"/submit\">\n")
		output += fmt.Sprintf("<table><tr><td>Your Justin.tv email address:</td><td><input type=\"text\" name=\"customer\"></td></tr></br>\n")
		output += fmt.Sprintf("<tr><td>Pickup location:</td><td><select name=\"location\">")
		output += fmt.Sprintf("<option value=\"San Francisco\">San Francisco</option>")
		output += fmt.Sprintf("<option value=\"Seattle\">Seattle</option>")
		output += fmt.Sprintf("<option value=\"New York\">New York</option>")
		output += fmt.Sprintf("<option value=\"London\">London</option>")
		output += fmt.Sprintf("<option value=\"Other\">Other</option>")
		output += fmt.Sprintf("</select>")
		output += fmt.Sprintf("</td></tr></table></br>\n")
	}
	if orderform < 3 {
		output += "<table cellpadding=2><tr><td>Item</td><td>Color</td><td>Size</td><td>Price</td><td>Quantity</td>"
	 	var itemNumber int = 1
		for _,lineitem := range o.Contents {
			output += "<tr>" + lineitem.Display()

			if orderform == 1 {
				output += "<td>" + QuantitySelect(fmt.Sprintf("%v",itemNumber),lineitem.Quantity) + "</td><tr>"
			} else { 
				output += "<td>" + fmt.Sprintf("%v",lineitem.Quantity)
			}
			itemNumber++
		}
		output += "</table>"
	} else {
		output += "||Item||Color||Size||Price||Quantity||\\n"
	 	var itemNumber int = 1
		for _,lineitem := range o.Contents {
			output += lineitem.DisplayJira()
			itemNumber++
		}
	}
		if orderform == 1 {
			output += fmt.Sprintf(`<p>Anything else?  Notes, or something you like that's not listed?</p>`)
			output += fmt.Sprintf(`<p><textarea name="notes" rows="4" cols="50"></textarea></p>`)
			output += fmt.Sprintf(`<input type="submit">`) 
		}
	return output
}

func (l *LineItem) Display() string{
	return fmt.Sprintf("<td>%v</td><td>%v</td><td>%v</td><td>$%v</td>",l.Description, l.Color, l.Size, l.Price)
}

func (l *LineItem) DisplayJira() string{
	return fmt.Sprintf("|%v|%v|%v|%v|%v|\\n",l.Description, l.Color, l.Size, l.Price,l.Quantity)
}

func QuantitySelect(name string, maxquantity int) string {
	selectbox := "<select name=\"" + name + "\">\n"
	i := 0
	for i <= maxquantity {
		selectbox += `<option value="` + fmt.Sprintf("%v",i) + `">` + fmt.Sprintf("%v",i) + `</option>` + "\n"
		i++ 
	}
	selectbox += "</select>\n"
	return selectbox
}