# Contributing to Puppet

If you are looking for a deeper dive into technical guidelines, see
[STANDARDS.md](STANDARDS.md)

## Filing issues

If you find a bug, you can file an issue on the repository here in GitHub.

## Contributing code

To contribute code, prepare a branch or fork with your changes, and then submit
a Pull Request on this repository.

### The Style Guide

Above all else, follow the official [Puppet Language Style
Guide](https://docs.puppetlabs.com/guides/style_guide.html).

### Namespaces

All first-party modules should have names which start with `twitch_`. This
helps avoid namespace conflicts when we use open source modules.

### Open Source Modules

Always search for existing open-source modules before attempting to write your
own. If an open-source module is adequate but unmaintained (or contribution is
impeded), fork the module into the GitHub organization for your team.

Never edit open-source modules we consume, unless we are running and
maintaining an internal fork.

### Binary Files

Never add binary files to this repository. You have two alternatives instead:

  1. Create a `.deb` package for your binaries, and use Puppet to install it
  2. Use S3 to store your binaries, and have Puppet download them

### Module Design

Follow the recommendation from Puppet Labs on creating new modules:

https://docs.puppetlabs.com/guides/module_guides/bgtm.html#step-two-module-structure

### Style / Linting

Your code should pass tests from `puppet-lint`. You can get `puppet-lint` from
the `gem` command:

    $ gem install puppet-lint

### Idempotency and Efficiency

Since Puppet is designed to bring a system to a particular state, and maintain
that state, your Puppet code should finish all of its changes in one Puppet
run. The second Puppet run should exit with code `0`, which means that the
desired state is achieved, and no further changes were made.

Jenkins will test for this, and will reject any proposed changes which result
in any exit code other than `0` on the second Puppet run.

### Tests

Before submitting any code for review, be sure to test it locally! Use the
included testing script to test locally in vagrant:

    $ bash tests/functional <twitch_role> <twitch_environment>

Submitting a pull request will also trigger a full testing round in Jenkins.
