class cassandra::params {
  $additional_jvm_opts        = []
  $auto_bootstrap             = false
  $auto_snapshot              = true
  $broadcast_address          = ''
  $broadcast_rpc_address      = $::ipaddress  # must be set, can't be 0.0.0.0
  $cluster_name               = 'Cassandra'
  $commitlog_directory        = '/var/lib/cassandra/commitlog'
  $compaction_throughput      = 16  # MB/s
  $concurrent_reads           = $::processorcount * 8
  $concurrent_writes          = $::processorcount * 8
  $data_file_directories      = ['/var/lib/cassandra/data']
  $disable_auth               = false
  $disk_failure_policy        = 'stop'
  $endpoint_snitch            = 'SimpleSnitch'
  $heap_newsize               = ''
  $hinted_handoff_enabled     = true
  $include_repo               = true
  $incremental_backups        = false
  $initial_token              = ''
  $internode_compression      = 'all'
  $jmx_port                   = 7199
  $listen_address             = $::ipaddress
  $max_heap_size              = ''
  $multithreaded_compaction   = false
  $native_transport_port      = 9042
  $num_tokens                 = 256
  $package_name               = 'dsc21'
  $partitioner                = 'org.apache.cassandra.dht.Murmur3Partitioner'
  $repo_enabled               = 1
  $repo_gpgcheck              = 0
  $repo_key                   = 'B999A372'
  $repo_name                  = 'datastax'
  $repo_pin                   = 200
  $repo_release               = 'stable'
  $repo_repos                 = 'main'
  $rpc_address                = '0.0.0.0'
  $rpc_port                   = 9160
  $rpc_server_type            = 'hsha'
  $saved_caches_directory     = '/var/lib/cassandra/saved_caches'
  $seeds                      = []
  $service_enable             = true
  $service_ensure             = 'running'
  $service_name               = 'cassandra'
  $snapshot_before_compaction = false
  $start_native_transport     = false
  $start_rpc                  = true
  $storage_port               = 7000
  $thread_stack_size          = 180
  $version                    = 'installed'

  $repo_baseurl = $::osfamily ? {
    'Debian' => 'http://debian.datastax.com/community',
    'RedHat' => 'http://rpm.datastax.com/community/',
    default  => undef,
  }

  $repo_gpgkey = $::osfamily ? {
    'Debian' => 'http://debian.datastax.com/debian/repo_key',
    'RedHat' => 'http://rpm.datastax.com/rpm/repo_key',
    default  => undef,
  }

  $config_path = $::osfamily ? {
    'Debian' => '/etc/cassandra',
    'RedHat' => '/etc/cassandra/conf',
    default  => fail("Unsupported osfamily: ${::osfamily}, module ${module_name} only supports osfamily Debian/RedHat")
  }
}
