# twitch_aws::eni is a small helper class to turn up elastic network
# interfaces.
class twitch_aws::eni (
  $interfaces = [],
) {
  validate_array($interfaces)

  # Add a directory to place files indicating that ENIs were successfully created
  file { '/opt/aws_enis':
    ensure => 'directory'
  }

  # ec2-net-utils is a twitch package of ec2's scripts for configuring routes
  # on ENI interfaces.
  package { "ec2-net-utils": }

  if $interfaces != [] {
    twitch_aws::setup_eni { $interfaces: }
  }
}
