define twitch_aws::setup_eni (
  $interface = $name,
) {
  exec { "add eni ${interface}":
      environment => [
        "INTERFACE=${interface}",
        "ACTION=add",
      ],
      command => "/etc/network/ec2net.hotplug add && echo 'success' > /opt/aws_enis/${interface}.nic",
      creates => "/opt/aws_enis/${interface}.nic",
      require => Package["ec2-net-utils"],
      notify => Exec["ifup ${interface}"],
  }

  exec { "ifup ${interface}":
      refreshonly => true,
  }
}
