#!/usr/bin/perl
use Getopt::Long;

%options=();

GetOptions("help" => \$opt_help, #flag
           "n=s" => \$number_of_devices,
           "m=s" => \$bond_method,
           "r=i" => \$rx_size,
           "i=s" => \$dev_name,
            "e" => $has_e1000e=1,
            "g" => \$use_orig_gw,
            "d=s" => \$devices,
            "l" => \$use_new_gateway_standard,
            "P" => \$use_dhcp,
          );

if(!defined($bond_method)) {
    $bond_method = "ad";
}

if(defined($opt_help)){

print "
$0:
    -h - help screen
    -i dev_name    - name of dev to use
    -m bond method - type of bond (rr default)
    -n #           - number of network devices
    -r rx_size     - size of ethtool -G rx (defaults to driver default)
";
exit(4);

}

@ifconfig=`ifconfig $dev_name`;
@netstat=`netstat -rn`;

foreach (@ifconfig)
{
 chomp();

  if ( /\s+HWaddr\s+(\w+:\w+:\w+:\w+:\w+:\w+)/) {
        $mac_address = $1;
    }
  if ( /inet addr:(\d+\.\d+\.\d+\.\d+)\s+Bcast:(\d+\.\d+\.\d+\.\d+)\s+Mask:(\d+\.\d+\.\d+\.\d+)/ ) {
	 $ipaddr = $1;
	 $broadcast = $2;
	 $netmask  = $3;
}
}

foreach (@netstat)
{
 chomp();

  if ( /^(\d+\.\d+\.\d+\.\d+)\s+0\.0\.0\.0\s+$netmask\s+U\s+/ ) {
	$network=$1;
  }
  if ( /^0\.0\.0\.0\s+(\d+\.\d+\.\d+\.\d+)\s+0\.0\.0\.0/ ) {
	$gateway=$1;
  }
}

@gwsplit = split(/\./, $gateway);

if ( (!defined($use_orig_gw)) && ($ipaddr  =~ m/[02468]$/ ) && ($gwsplit[3] =~ m/[13579]$/ ) ) { $gwsplit[3]++ };
if ( (!defined($use_orig_gw)) && ($ipaddr  =~ m/[13579]$/ ) && ($gwsplit[3] =~ m/[02468]$/ ) ) { $gwsplit[3]-- };

if ( ($gwsplit[3] =~ m/[02468]$/ ) && (defined($use_new_gateway_standard)) ) { $gwsplit[3]-- };

print
"auto lo
iface lo inet loopback

";

print "auto bond0\n";

if (defined($use_dhcp)) {

print "iface bond0 inet dhcp\n";

} else {

print "iface bond0 inet static
    address $ipaddr
    netmask $netmask
    network $network
    broadcast $broadcast
    gateway $gwsplit[0].$gwsplit[1].$gwsplit[2].$gwsplit[3]
    dns-nameservers 10.1.12.48 10.1.61.16 10.1.61.23 10.1.12.47
";

}

print "    hwaddress ether $mac_address
    bond-slaves none
    bond-miimon 100";

print "\n";

if ($bond_method eq "ad") {
	printf "    bond-mode 802.3ad\n    bond-lacp-rate 1\n    bond-xmit_hash_policy layer3+4\n";
} elsif ($bond_method eq "xor") {
	printf "    bond-mode balance-xor\n    bond-xmit_hash_policy layer3+4\n";
} elsif ($bond_method eq "tlb") {
	printf "    bond-mode balance-tlb\n    bond-xmit_hash_policy layer3+4\n";
} else {
	printf "    bond-mode balance-$bond_method\n";
}

print "\n";

for($i = 0; $i < $number_of_devices; $i++) {
    push (@device_names, "eth$i");
}

if ($devices) {
    @device_names = split(/,/,$devices) ;
}

foreach (@device_names) {
$device_name = $_;
print"auto $device_name
iface $device_name inet manual
    bond-master bond0\n";
if (defined($rx_size)) {
    print "    hardware-dma-ring-rx $rx_size\n";
}
if (defined($has_e1000e)) {
    print "    hardware-irq-coalesce-rx-usecs $has_e1000e\n";
}
print "\n";
}

@ip_aliases = `ifconfig | grep -A1 ^$dev_name\:` ;
$ip_alias_count=0;

foreach (@ip_aliases)
{
    if ( /inet addr:(\d+\.\d+\.\d+\.\d+)\s+Bcast:\d+\.\d+\.\d+\.\d+\s+Mask:\d+\.\d+\.\d+\.\d+/ ) {
        $ipaddr = $1;
        print "auto bond0:$ip_alias_count\niface bond0:$ip_alias_count inet static\n\taddress $ipaddr\n\tnetmask 255.255.255.255\n\n";
        $ip_alias_count++;
    }
}
