#!/bin/bash

PATH=$PATH:/bin:/sbin:/usr/sbin:/usr/bin

kernel_filter() {
  # filter out all installed packages, sort by version numbers
  grep "ok installed" | awk '{print $1}' | sort -t . -k 1,1nr -k 2,2nr -k 3,3r
}

all_kernels() {
  # list kernel packages matching ubuntu packaging standards
  dpkg-query --showformat='${Package} ${Status}\n' -W "linux-image-[0-9]*"
}

KERNEL_DEBS=($(all_kernels | kernel_filter))
# kernel debs is sorted in order of newest kernel first
# filter the array by removing entries
# unset the the highest kernel version
unset KERNEL_DEBS[0]
# remove current kernel
KERNEL_DEBS=(${KERNEL_DEBS[@]//*$(uname -r)*})

# if we have more than one kernel to remove
if [ ${#KERNEL_DEBS[@]} -gt 0 ]; then
  # all debian packages share common names, swap image with headers
  HEADER_DEBS=($(echo ${KERNEL_DEBS[@]} | sed 's/image/headers/g'))
  echo Removing \(${#KERNEL_DEBS[@]}\) unused kernels: ${KERNEL_DEBS[@]}
  echo Removing \(${#HEADER_DEBS[@]}\) unused kernel headers: ${HEADER_DEBS[@]}
  apt-get purge -qqy ${KERNEL_DEBS[@]} ${HEADER_DEBS[@]} >/dev/null
fi
