class twitch_bare_metal::bond_setup (
  $bond_slaves = $twitch_bare_metal::bond_setup::params::bond_slaves,
  $bond_mode   = $twitch_bare_metal::bond_setup::params::bond_mode,
  $bond_config = {},
) inherits twitch_bare_metal {

  validate_hash($bond_config)
  validate_array($bond_slaves)

  # take defaults, and merge them with overrides
  $bond_config_merged = merge($twitch_bare_metal::bond_setup::params::bond_config, $bond_config)

  # declare anchors
  anchor { "twitch_bare_metal::bond_setup::start": }
  anchor { "twitch_bare_metal::bond_setup::end": }

  # install bond_package ifenslave-2.6
  package { $bond_package: }

  case empty($bond_slaves) {
    # our bond slaves are empty
    true: {
      # TODO: 1G bonding???
      Anchor['twitch_bare_metal::bond_setup::start']
      -> notify { "No bond slave interfaces found. Doing nothing.": }
      -> Anchor['twitch_bare_metal::bond_setup::end']
    }
    # if not empty, we have bond slaves
    false: {
      # setup master bond interface(s)
      if !str2bool($is_virtual) {
        $bond_interfaces = keys($bond_config_merged)
        twitch_bare_metal::bond_setup::interface { $bond_interfaces: }
        # setup slave interfaces
        twitch_bare_metal::bond_setup::interface { $bond_slaves: }

        $msg = join([
          "bond slaves: ${bond_candidates}",
          "primary mac: ${macaddress_primary}"
        ], ' ')

        # bonding package comes before any interface is added
        Anchor['twitch_bare_metal::bond_setup::start']
        -> Package[$bond_package]
        -> notify { $msg: }
        -> Bond_setup::Interface <| |>
        -> Anchor['twitch_bare_metal::bond_setup::end']
      }
    }
  }

  # here for manual hackery
  file { "/usr/local/bin/bond-setup.pl":
    ensure => 'present',
    source => "puppet:///modules/${module_name}/bond-setup.pl",
    owner  => 'root',
    group  => 'root',
    mode   => 0755
  }
}
