# Deletes unused kernel packages from the boot partition
# Only needed on bare metal systems which have a separate boot partition
# For some reason KVM instances also have a dedicated /boot partition
class twitch_bare_metal::clear_kernels {

  # TODO: Rename to clear_kernels_debian.sh and create clear_kernels_redhat.sh
  if $::osfamily == 'Debian' {
    file { "/usr/local/bin/clearkernels":
      ensure => present,
      owner  => "root",
      group  => "root",
      mode   => "0755",
      source => "puppet:///modules/${module_name}/clear_kernels.sh",
    }

    $hour = fqdn_rand(6) + 12
    $minute = fqdn_rand(60)

    cron { "clear old kernels":
      user    => "root",
      hour    => $hour,
      minute  => $minute,
      weekday => "tuesday",
      command => "/usr/local/bin/clearkernels 2&>/dev/null",
      require => File["/usr/local/bin/clearkernels"],
    }
  }

}
