# Configures GRUB for bare metal systems
class twitch_bare_metal::grub {
  exec { 'display_grub_menu_via_serial':
    command => "sed -i '/^GRUB_HIDDEN_TIMEOUT/s|^|#|' /etc/default/grub",
    onlyif  => "grep ^GRUB_HIDDEN_TIMEOUT /etc/default/grub",
    notify  => Exec["/usr/sbin/update-grub"]
  }

  exec { 'replace_splash':
    command => 'sed -i "/splash/s|||" /etc/default/grub',
    onlyif  => "grep 'splash' /etc/default/grub",
    notify  => Exec["/usr/sbin/update-grub"]
  }

  exec { 'replace_quiet':
    command => 'sed -i "/quiet/s|||" /etc/default/grub',
    onlyif  => "grep 'quiet' /etc/default/grub",
    notify  => Exec["/usr/sbin/update-grub"]
  }

  exec { 'targeted_initrd':
    command => 'sed -i "/^MODULES/s|=most|=dep|" /etc/initramfs-tools/initramfs.conf',
    onlyif  => 'grep ^MODULES=most /etc/initramfs-tools/initramfs.conf',
    notify  => Exec["/usr/sbin/update-grub"],
  }

  exec { "/usr/sbin/update-grub":
    refreshonly => true,
  }
}
