# This module installs and configures all things necessary for our bare metal
class twitch_bare_metal () inherits twitch_bare_metal::params {
  # Need twitch_core for apt mirrors, etc.
  require twitch_core

  anchor { "${module_name}::begin": }
  anchor { "${module_name}::base_end": }
  anchor { "${module_name}::end": }

  Anchor["${module_name}::begin"] ->
  class { "${module_name}::packages": } ->
  class { "${module_name}::clear_kernels": } ->
  class { "${module_name}::disktune": } ->
  class { "${module_name}::grub": } ->
  class { "${module_name}::mcelog": } ->
  class { "${module_name}::modprobe_blacklist": } ->
  Anchor["${module_name}::base_end"]

  # CentOS sets up ttys automatically via systemd
  if $::osfamily == 'Debian' {
    Anchor["${module_name}::base_end"] ->
    class { "${module_name}::serial_console": } ->
    Anchor["${module_name}::end"]
  }
}
