# Installs and configures MCELog for monitoring hardware RAID
class twitch_bare_metal::mcelog {
  service { "mcelog":
    ensure => running,
    enable => true,
  }

  logrotate::rule { "mcelog":
    ensure       => present,
    path         => '/var/log/mcelog',
    rotate_every => 'day',
    compress     => true,
    rotate       => 30,
    ifempty      => false,
    missingok    => true,
    copytruncate => true,
    create       => true,
    create_mode  => '0644',
    create_owner => 'root',
    create_group => 'root',
  }
}
