# Installs packages required on Twitch bare metal systems
class twitch_bare_metal::packages {
  $base_packages = [
    'dmidecode',
    'ethtool',
    'irqbalance',
    'mcelog',
    'memtest86+',
    'smartmontools',
  ]

  $os_packages = $::osfamily ? {
    'Debian' => [
      'megacli',
      'ladvd',
      'freeipmi-tools',
    ],
    'RedHat' => [
      'freeipmi',
      'ladvd-unstable'
    ],
    default => [],
  }

  $bare_metal_packages = concat($os_packages, $base_packages)

  package { $bare_metal_packages:
    ensure => installed,
  }
}
