class twitch_bare_metal::params {

  # Parameters for twitch_bare_metal::bond_setup below
  $bond_package = 'ifenslave-2.6'

  # Determine slave interface names
  if ($interfaces_10g) {
    $bond_candidates    = $interfaces_10g
    $macaddress_primary = $macaddress_primary_10g
  } else {
    $bond_candidates    = ''
  }
  $bond_slaves = split($bond_candidates, ',')

  # This is our default bonding mode
  $bond_mode   = 'ad'

  # Declare one bond interface
  # Configuration can be overridden by Hiera
  $bond_config = { 'bond0' => {} }
}
