# Configures serial consoles for various types of bare metal systems
class twitch_bare_metal::serial_console {
  # Set the default TTY for serial connections
  $ttyserial = $::manufacturer ? {
    'Supermicro' => 'ttyS1',
    'iXsystems'  => 'ttyS1',
    'Rackable'   => 'ttyS1',
    'Racklive'   => 'ttyS1',
    default      => 'ttyS0',
  }

  # Set the TTY baud rate
  $speed = '115200'

  # Write the configuration into Upstart
  file { "/etc/init/${ttyserial}.conf":
    content => template("${module_name}/serial_console.init.erb"),
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
  }
}
