#!/usr/bin/python

import subprocess
import re
import os.path
import sys
import time
import argparse
import requests


def main():
    argobj = args()
    backuphost = argobj.backuphost
    cluster = getclustername()
    t = time.localtime()
    curday = time.strftime("%Y%m%d", t)
    rootdir = '/var/lib/cassandra/data'
    sourcehost = subprocess.check_output(["/usr/bin/facter", "hostname"])
    sourcehost = sourcehost.rstrip()
    rsyncdest = '%s:/mnt/postgres_backup/cassandra/%s/%s/%s' % (
        backuphost, cluster, sourcehost, curday)
    snapshotcmd = ['/usr/bin/nodetool', 'snapshot', '-t', curday]
    snapshotps = subprocess.call(snapshotcmd)
    time.sleep(5)
    findcmd = ['/usr/bin/find', rootdir, '-type', 'd', '-name', curday]
    findps = subprocess.Popen(
        findcmd, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    for directory in findps.stdout.readlines():
        directory = directory.rstrip()
        rsynccmd = [
            '/usr/bin/rsync', '-avRq', '-e', '/usr/bin/ssh', directory,
            rsyncdest]
        rsyncps = subprocess.call(rsynccmd)
    time.sleep(5)
    clearsnapcmd = ['/usr/bin/nodetool', 'clearsnapshot', '-t', curday]
    clearps = subprocess.call(clearsnapcmd)
    timestamp_consul(curday, cluster)


def args():
    parser = argparse.ArgumentParser()
    parser.add_argument(
        '--backuphost', type=str, help='Destination host'
        'If empty defaults is postgres-backup-4cf1dc.sfo01.justin.tv',
        default='postgres-backup-4cf1dc.sfo01.justin.tv')
    args = parser.parse_args()
    return args


def getclustername():
    clusterquerycmd = ['/usr/bin/nodetool', 'describecluster']
    clusterqueryps = subprocess.Popen(
        clusterquerycmd, stdout=subprocess.PIPE)
    for clusterinfoline in clusterqueryps.stdout.readlines():
        matchobj = re.search(r'Name: (\w+)', clusterinfoline)
        if matchobj:
            clustername = matchobj.group(1).rstrip()
            return clustername
    return None


def timestamp_consul(dayrecord, clustername):
    consul_url = "http://consul.internal.justin.tv/v1/kv/backups/cassandra/%s/latest?dc=sfo01" % clustername
    r = requests.put(consul_url, data=dayrecord)
    return None


if __name__ == "__main__":
    main()
