#!/bin/bash

## NOTE: this script relies on a .cassandra/cqlshrc file under ~cassbackup
# in format:
# [authentication]
# username = cassandra
# password = *********
#
## TODO: store and retrieve backup hostname using consul for rsync
# get list of tables. folder names on disk differ from folder names in cassandra

hostip=`facter ipaddress`
backuphost='postgres-backup-4cf1dc.sfo01.justin.tv'
tablelist=(authorizations-7a691200e21e11e480f41f0c600ab759 codes-717ac370e21c11e480f41f0c600ab759 tokens-7be021a0e21e11e480f41f0c600ab759 user_authorizations-71f0ddd0e21c11e480f41f0c600ab759)
realtablelist=(authorizations codes tokens user_authorizations)
latestbackup=`curl -s http://consul.internal.justin.tv/v1/kv/backups/cassandra/auth/latest?dc=sfo01|jq --raw-output '.[0].Value'|base64 --decode`

rm -rf /var/lib/cassandra/restore/owl_staging/*

for table in ${realtablelist}
do
    echo "truncate owl_staging.${table};"|cqlsh
done

sleep 2

for table in ${tablelist[@]}
do
	rsync -avP $backuphost:/mnt/postgres_backup/cassandra/auth/auth-cassandra-6ba550/${latestbackup}/var/lib/cassandra/data/owl/${table}/snapshots/${latestbackup} /var/lib/cassandra/restore/owl_staging/${table}
	sleep 2
	find /var/lib/cassandra/restore/owl_staging/${table}/${latestbackup} -type f -exec mv {} /var/lib/cassandra/restore/owl_staging/${table}/ \; 
	/usr/bin/sstableloader -u cassandra -pw cassandra -d ${hostip} /var/lib/cassandra/restore/owl_staging/${table}/
done
