class twitch_cassandra::monitoring {

  $graphite_suitable_hostname = regsubst($fqdn,'(\.)','_','G')

  package { "cassandra-metrics-graphite-jar":
    ensure  => present,
  }

  package { "libmx4j-java":
    ensure => present,
  }

  file { "/usr/share/cassandra/lib/mx4j-tools.jar":
    ensure    => link,
    target    => "/usr/share/java/mx4j-tools.jar",
    require => [Package["libmx4j-java"], Class['cassandra']]
  }

  file { "/usr/share/diamond/collectors/cassandra":
    ensure  => directory,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    require => Package["diamond"]
  }

  file { "/usr/share/diamond/collectors/cassandra/cass-requests.py":
    ensure  => present,
    content  => template("${module_name}/cass-requests.py.erb"),
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    require => File["/usr/share/diamond/collectors/cassandra"]
  }

  file { "/etc/cassandra/graphite.yaml":
    content => template("${module_name}/graphite.yaml.erb"),
  }


}
