class twitch_cassandra::opscenter inherits twitch_cassandra {

  package { 'opscenter':
    ensure  => installed,
    require => Class['cassandra'],
  }

  package { 'datastax-agent':
    ensure => installed,
  }

  sudo::conf { 'opscenter':
    priority => 10,
    source   => "puppet:///modules/${module_name}/opscenter-agent-sudoers",
    require => [Package['opscenter'], Package['datastax-agent']]
  }

  file { $datastax_agent_conf:
    ensure  => present,
    owner   => 'opscenter-agent',
    group   => 'opscenter-agent',
    mode    => '0644',
    content => template("${module_name}/datastax-agent/address.yaml.erb"),
    notify  => Service['datastax-agent'],
    require => Package['datastax-agent'],
  }

  user { 'opscenter-agent':
    name    => 'opscenter-agent',
    ensure  => present,
    gid     => opscenter-agent,
    shell   => '/bin/false',
    home    => '/usr/share/datastax-agent',
    comment => 'DataStax Agent',
  }

  group { 'opscenter-agent':
    name    => 'opscenter-agent',
    ensure  => present,
  }

Group['opscenter-agent']->User['opscenter-agent']->File[$datastax_agent_conf]

  service { 'opscenterd':
    ensure  => running,
    require => Package['opscenter'],
  }

  service { 'datastax-agent':
    ensure  => running,
    require => Package['datastax-agent'],
  }
}
