class twitch_cassandra::params {
  $compaction_throughput  = '32'       # megabytes per second
  $datastax_agent_conf    = '/var/lib/datastax-agent/conf/address.yaml'
  $heap_newsize           = '1200M'    # recommendation from datastax
  $hinted_handoff_enabled = true
  $java_distribution      = 'oracle-jdk'
  $java_version           = 'present'  # we have 7u67 in our repo
  $max_heap_size          = '8G'       # recommendation from datastax (4-8gb)
  $opscenter_host         = undef      # set in hiera/cluster/${cluster}.yaml
  $package_name           = 'dsc21'    # datastax community edition 2.1.x
  $package_version        = '2.1.2-1'
  $backup                 = false
  $restore                = false
  $cass_lib_dir           = '/usr/share/cassandra/lib'
  $include_repair         = 'true'     # using string true expecting overrides from hiera
  $include_opscenter      = 'false'     # the init is validatig string and not bool
  $include_monitoring     = 'true'     #
  $backupday              = 'saturday'
  $backuphour             = '17'
  $data_file_directories  = ['/var/lib/cassandra/data']
  $commitlog_directory    = '/var/lib/cassandra/commitlog'
  if ($::ec2_instance_id != "") {
    $listen_address       = $::ec2_local_ipv4
  } else {
    $listen_address       = $::ipaddress
  }
  $disable_auth           = false
}
