class twitch_cassandra::restorestaging {

  file { "/usr/local/bin/restore.sh":
    ensure  => present,
    owner   => 'cassbackup',
    group   => 'cassbackup',
    mode    => '0700',
    source  => "puppet:///modules/${module_name}/restore.sh",
  }

  file { "/var/lib/cassandra/restore":
    ensure  => 'directory',
    owner   => 'cassbackup',
    group   => 'cassbackup',
    mode    => '0755',
  }

  file { "/var/lib/cassandra/restore/owl_staging":
    ensure  => 'directory',
    owner   => 'cassbackup',
    group   => 'cassbackup',
    mode    => '0755',
  }

  cron { cassrestorestaging:
      command => "/usr/local/bin/restore.sh",
      user    => cassbackup,
      hour    => 0,
      minute  => 1,
  }
}
