class twitch_changelog::config inherits twitch_changelog {

  concat{'requirements-puppet.txt':
    path => "/var/www/changelog/requirements-puppet.txt",
    require => Package['twitch-changelog'],
  }
  
  concat::fragment{'requirements.txt':
    target => 'requirements-puppet.txt',
    require => Package['twitch-changelog'],
    source => '/var/www/changelog/requirements.txt',
    order => 1,
  }

  concat::fragment{'newline':
    target => 'requirements-puppet.txt',
    content => "\nuWSGI==2.0.12\n",
    order => 5,
  }

  concat::fragment{'requirements-postgres.txt':
    target => 'requirements-puppet.txt',
    require => Package['twitch-changelog'],
    source => '/var/www/changelog/requirements-postgres.txt',
    order => 10,
  }

  python::virtualenv{"/var/www/changelog/virtualenv":
    ensure => present,
    require =>Package['twitch-changelog'],
  }

  python::requirements{"/var/www/changelog/requirements-puppet.txt":
    virtualenv => "/var/www/changelog/virtualenv",
    require => [Python::Virtualenv["/var/www/changelog/virtualenv"],
                Concat['requirements-puppet.txt'],
                ],
    manage_requirements => false,
   }

   file{"/var/www/changelog/custom_settings.py":
     mode => "0600",
     owner => "changelog",
     group => "changelog",
     content => template("${module_name}/custom_settings.py.erb"),
     require => Package['twitch-changelog'],
   }
}
