class twitch_changelog::service inherits twitch_changelog {
  require twitch_nginx
  
  $changelog_pidfile = "/var/www/changelog/changelog.pid"
  twitch_monit::check {"changelog":
    pidfile => $changelog_pidfile,
    cwd => "/var/www/changelog",
    check_interval => 5,
    uid => "changelog",
    gid => "changelog",
    command => "CHANGELOG_SETTINGS_PATH=./custom_settings.py virtualenv/bin/uwsgi --socket :3031 --master --processes 4 --wsgi-file application.wsgi --logger syslog:changelog,local4 --pidfile=${changelog_pidfile} --die-on-term 2>&1"
  }
  nginx::resource::vhost { 'changelog.internal.justin.tv':
    listen_port => 80,
    access_log  => "/var/log/nginx/changelog_access.log",
    error_log   => "/var/log/nginx/changelog_error.log",
    add_header  => {
      "Access-Control-Allow-Methods" => '"GET, OPTIONS"',
      "Access-Control-Allow-Headers" => '"origin, authorization, accept"',
    },
    uwsgi => "127.0.0.1:3031",
  }
}
