class twitch_chronograf (
  $manage_install = true,
  $version = '0.10.0',
  $bind_ip = '0.0.0.0',
  $bind_port = '10000',
  $config_file = '/opt/chronograf/config.toml',
  $mysql_dsn = '',
  $local_db_file = '/opt/chronograf/chronograf.db',
  $query_response_bytes_limit = '2500000',
) {

  if $manage_install {
    package { 'chronograf':
      ensure => latest,
    }
  }

  file { $config_file:
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    content => template("${module_name}/config.toml.erb"),
    require => [
      Package['chronograf'],
    ],
    notify => [
      Service['chronograf'],
    ]
  }

  service { 'chronograf':
    ensure  => running,
    enable  => true,
    require => [
      Package['chronograf'],
    ]
  }

}
