#!/usr/bin/perl

use Switch '__';
use Getopt::Std;

my $opt_string = 'w:c:h';
getopts( "$opt_string", \%opt );
# print out usage if needed
if (defined $opt{h} ) { usage(); }
if (defined $opt{w} ) { ($mem_warn_percent,$swap_warn_percent) = split(/:/,$opt{w}); }
if (defined $opt{c} ) { ($mem_cirt_percent,$swap_crit_percent) = split(/:/,$opt{c}); }


if ($swap_warn_percent >= $swap_crit_percent || $mem_warn_percent >= $mem_cirt_percent ) {

print "usage error: warning value cannot be equal to or greater then critical value\n";
usage();
}


sub usage () {
print "usage: $0 -w [mem_warn:swap_warn] -c [mem_crit:swap_crit] -[h]

example
  $0 -w 10:20 -c 30:40

";
exit(1);
}

open(MEMINFO,'/proc/meminfo');

while (<MEMINFO>) {

  if (/^(\w+):\s+(\d+) kB/) {
    $current_var = $1;
    $current_value = $2;

    switch ($current_var) {
      case "SwapFree"  { $swapfree  = $current_value }
      case "SwapTotal" { $swaptotal = $current_value }
      case "MemTotal"  { $memtotal  = $current_value }
      case "MemFree"   { $memfree   = $current_value }
      case "Buffers"   { $buffers   = $current_value }
      case "Cached"    { $cached    = $current_value }
    }
  }
}
close MEMINFO;

$total_used_memory=$memtotal-($cached+$buffers+$memfree);
$total_used_swap=$swaptotal-$swapfree;
$total_used_memory_formated = sprintf("%.2f",($total_used_memory/$memtotal)*100);
if ($swaptotal > 0) {
    $total_used_swap_formated   = sprintf("%.2f",($total_used_swap/$swaptotal)*100);
} else {
    $total_used_swap_formated = 0.00 ;
}

$crit_mem = $memtotal * $mem_cirt_percent/100;
$warn_mem = $memtotal * $mem_warn_percent/100 ;

$crit_swap = $swaptotal * $swap_crit_percent/100;
$warn_swap = $swaptotal * $swap_warn_percent/100;

switch ($total_used_memory) {
        $PREMPT_CONTENT = " MEM:$total_used_memory_formated%";
        case  ( __ >= $crit_mem )  { $exit_value[2]=1 ; $CONTENT.=$PREMPT_CONTENT ; last }
        case  ( __ >= $warn_mem )  { $exit_value[1]=1 ; $CONTENT.=$PREMPT_CONTENT }
}

switch ($total_used_swap) {
        $PREMPT_CONTENT = " SWAP:$total_used_swap_formated%";
        case  ( 0 ) { last }
        case  ( __ >= $crit_swap ) { $exit_value[2]=1 ; $CONTENT.=$PREMPT_CONTENT; last }
        case  ( __ >= $warn_swap ) { $exit_value[1]=1 ; $CONTENT.=$PREMPT_CONTENT }
}

### print response based on error level

switch ($exit_value) {
        case { $exit_value[2] > 0 } { print "CRITICAL: $CONTENT " ; $return_this=2 ;}
        case { $exit_value[1] > 0 } { print "WARN: $CONTENT" ; $return_this=1 ;}
        else { print "OK: mem=$total_used_memory_formated% swap=$total_used_swap_formated%"; }
}

print "|percent_memory_used=$total_used_memory_formated;$mem_warn_percent;$mem_cirt_percent;0;100 percent_swap_used=$total_used_swap_formated;$swap_warn_percent;$swap_crit_percent;0;100\n";
exit($return_this);
