# hostname.rb
# checks to see if legacy hostname 'standard'
# sets facts:
#   pop
#   pqdn

fqdn = Facter.value('fqdn')
facts = Hash.new

# if we have fqdn fact
if not fqdn.nil?
  sfqdn = fqdn.split('.')
  has_pop = sfqdn.length >= 4
  facts = {
    # Lookup from the end of the array to allow arbitrarily long hostnames:
    'twitch_pop' => has_pop ? sfqdn[-3] : 'sfo01',
    'twitch_pqdn' => has_pop ? sfqdn[0..-3].join('.') : Facter.value('hostname')
  }
end

# for ec2 instances, set the pop automatically instead of parsing the hostname
if Facter.value('ec2_instance_id') != nil
  # trim the availability zone letter to yield the region name
  aws_region = Facter.value('ec2_placement_availability_zone').slice(0..-2)
  # us-west-2 was incorrectly named us-west2 when it was created, so we need to
  # do some evil here...
  if aws_region == 'us-west-2'
    aws_region = 'us-west2'
  end
  facts['twitch_pop'] = aws_region
end

# loop through hash to create facts
facts.each do |fact,value|
  Facter.add(fact) { setcode { value } }
end
