module Puppet::Parser::Functions
  newfunction(:ldap_users,
              :type => :rvalue,
              :doc => <<-EOS

    ldap_users()

    takes a group name, and optional reject list to reject attributes of passwd

    queries ldap using getent to find uids in given group
    returns hash to pass to create_resources()

    ex:
        ldap_users('syseng', ['gid'])

    returns:
        {'username' => {
          'uid' => uid,
          'comment' => name,
          'home' => home,
          'shell' => shell
          }
        }
    EOS
    ) do |args|
    # take the first argument which is group, otherwise default to syseng
    group = args.shift || 'syseng'
    # enable second argument to be an array to check to reject for params
    reject_list = [args.shift || []].flatten
    users = `getent group #{group}`.chomp
    return {} if users.empty?
    users = users.split(':').last.split(',').uniq
    # format for create_resources()
    user_map = {}
    users.each do |user|
      passwd = `getent passwd #{user}`.chomp.split(':')
      uid, gid, name, home, shell = passwd[2..-1]
      user_map[user] = {
        'uid' => uid,
        'comment' => name,
        'gid' => gid,
        'home' => home,
        'shell' => shell
      }.reject { |k,v| k if reject_list.include?(k) }
    end
    return user_map
  end
end
