#
# consul.rb
#
# common consul ruby functions

require 'net/http'
require 'uri'
require 'json'

def consul_api_call(url)
  res = Net::HTTP.get_response(url)
  if res.code != "200"
    # TODO: Better errors
    raise(Puppet::ParseError, "Unable to lookup from consul. URL: #{url}; Code: #{res.code}")
  end

  if res.content_type == "application/json"
    return JSON.parse(res.body)
  else
    return res.body
  end

end

def datacenters(consul_server, name)
  if name != "all"
    return [name]
  end

  url = URI::join("http://#{consul_server}/v1/catalog/datacenters")
  return consul_api_call(url)
end
