module Puppet::Parser::Functions
  newfunction(:map_ssh_keys,
              :type => :rvalue,
              :doc => <<-EOS

    map_ssh_keys()

    takes a hash of {'uid' => [ssh_keys]}
    returns hash to pass directly to create_resources()

    ex:
        map_ssh_keys({
          'user1' => ['ssh-rsa AAAAAwe978fywbhdvcikuhsad789fh8wb3rtubnuisdfisdf.... stuff@things']
        })

    returns:
        {'user1-stuff@things' => {
          'key' => 'AAAAAwe978fywbhdvcikuhsad789fh8wb3rtubnuisdfisdf....',
          'type' => 'ssh-rsa',
          'user' => 'user1'
          }
        }
    EOS
    ) do |args|
    if not args.first.kind_of?(Hash)
      raise Puppet::ParseError, "map_ssh_keys: takes 1 hash ({'uid' => [ssh_keys]})"
    end
    key_map = {}
    args.first.each do |user,keys|
      # keep a count of keys in case of uniq resource name
      count = 0
      keys.each do |keydata|
        count += 1
        type, key = keydata.split[0..1]
        comment = keydata.split[2..-1].join(' ')
        # use comment if exists in resource name, otherwise use comment
        name = [user, comment || count].compact.join('-')
        if (key.nil? || key.empty?) or (type.nil? || type.empty?)
          # if bogus data lets not add to hash
          break
        end
        key_map[name] = {
          'key' => key,
          'type' => type,
          'user' => user
        }
      end
    end
    return key_map
  end
end
