# Configures Twitch LDAP authentication
class twitch_core::authentication::ldap (
  $ldap_server = 'ldap-vip.internal.justin.tv'
) {
  $lowercase_family = downcase($::osfamily)
  class {"twitch_core::authentication::ldap::${lowercase_family}": }

  file { '/etc/nsswitch.conf':
    ensure => 'present',
    source => "puppet:///modules/${module_name}/ldap/nsswitch-${::osfamily}.conf",
    owner  => 'root',
    group  => 'root',
    mode   => '0444',
  }
}
