#class twitch_core::authentication::ldap::debian
class twitch_core::authentication::ldap::debian {
  $ldap_server = $::twitch_core::authentication::ldap::ldap_server

  file { '/etc/default/libnss-db':
    ensure => 'present',
    group  => 'root',
    owner  => 'root',
    mode   => '0644',
    source => "puppet:///modules/${module_name}/ldap/libnss-db.default",
  }

  $minute = fqdn_rand(60)
  cron { 'nss_updatedb':
    command => '/usr/sbin/nss_updatedb ldap passwd > /dev/null; /usr/sbin/nss_updatedb ldap group > /dev/null',
    user    => 'root',
    minute  => $minute,
    hour    => 0,
  }

  file { '/etc/ldap.conf':
    ensure  => 'present',
    content => template("${module_name}/authentication/ldap.conf.erb"),
    owner   => 'root',
    group   => 'root',
    mode    => '0444',
  }

  file { '/etc/ldap/ldap.conf':
    ensure => 'present',
    source => "puppet:///modules/${module_name}/ldap/ldap.conf",
    owner  => 'root',
    group  => 'root',
    mode   => '0444',
  }
}
