#class twitch_core::authentication::ldap::redhat
class twitch_core::authentication::ldap::redhat {
  $ldap_server = $::twitch_core::authentication::ldap::ldap_server

  file { '/etc/nslcd.conf':
    ensure  => 'present',
    content => template("${module_name}/authentication/nslcd.conf.erb"),
    owner   => 'root',
    group   => 'root',
    mode    => '0400',
    notify  => Service['nslcd'],
  }

  service { 'nslcd':
    ensure    => 'running',
    enable    => true,
    subscribe => File['/etc/ldap.conf'],
    require   => Package['nss-pam-ldapd'],
  }

  # ssh-ldap-pubkey expects this file to exist and use the Debian-style syntax
  # so we just create it manually here.
  file { '/etc/ldap.conf':
    ensure  => 'present',
    content => template("${module_name}/authentication/pubkeyldap.conf.erb")
  }

  file { '/etc/openldap/ldap.conf':
    ensure => 'present',
    source => "puppet:///modules/${module_name}/ldap/ldap.conf",
    owner  => 'root',
    group  => 'root',
    mode   => '0444',
  }
}
