# Configures Pluggable Authentication Modules (PAM)
class twitch_core::authentication::pam (
  $allowed_groups = []
) {
  validate_array($allowed_groups)
  $lowercase_family = downcase($::osfamily)
  class {"twitch_core::authentication::pam::${lowercase_family}": }


  # Configure LDAP groups permitted to authenticate
  # Base allowed groups always have access to all systems
  $base_allowed_groups = [
    'syseng',
    'infra',
    $::twitch_role,
    join(['host-', regsubst($::fqdn, '\.', '-', 'G')], '')
  ]

  # The union of $base_allowed_groups and Hiera groups are used
  $all_allowed_groups = concat($base_allowed_groups, $allowed_groups)
  file { '/etc/allowed_groups':
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => join($all_allowed_groups, "\n"),
  }
}
