#class twitch_core::authentication::params - params for the auth module
class twitch_core::authentication::params {
  # Default settings for SSH
  # Can be overridden with Hiera in twitch_core::authentication::ssh
  $ssh_options = {
    'Host *'                      => {
      'StrictHostKeyChecking'     => 'no',
      'SendEnv'                   => 'LANG LC_*',
      'HashKnownHosts'            => 'yes',
      'GSSAPIAuthentication'      => 'yes',
      'GSSAPIDelegateCredentials' => 'no',
      'UseRoaming'                => 'no',
    }
  }



  case $::osfamily {
    'Debian': {
      $sshd_ensure = $::lsbdistcodename ? {
        'precise' => '1:6.6p1-2~precise1',
        'trusty'  => '1:6.6p1-2ubuntu2',
        'xenial'  => '1:7.2p2-4ubuntu2.1'
      }
      $ssh_pubkey_wrapper = '/usr/local/bin/ssh-ldap-pubkey-wrapper'
      $sftp_server_bin    = '/usr/lib/openssh/sftp-server'
      $host_keys          = [
        '/etc/ssh/ssh_host_dsa_key',
        '/etc/ssh/ssh_host_ecdsa_key',
        '/etc/ssh/ssh_host_rsa_key',
      ]
    }
    'RedHat': {
      $sshd_ensure = '6.6.1p1-25.el7_2'
      $ssh_pubkey_wrapper = '/usr/bin/ssh-ldap-pubkey-wrapper'
      $sftp_server_bin    = '/usr/libexec/openssh/sftp-server'
      $host_keys          = [
        '/etc/ssh/ssh_host_rsa_key',
        '/etc/ssh/ssh_host_ecdsa_key',
        '/etc/ssh/ssh_host_ed25519_key',
      ]
    }
    default: {
      #fail the manifest with a message intentionally (dont rely on missing default statement)
      fail("${::hostname}: Module ${::module_name} does not support operatingsystem ${::operatingsystem}")
    }
  }

  # Default settings for SSHD
  # Can be overridden with Hiera in twitch_core::authentication::sshd
  $sshd_options = {
    'AcceptEnv'                       => 'LANG LC_*',
    'AddressFamily'                   => 'inet',
    'AuthorizedKeysCommand'           => $ssh_pubkey_wrapper,
    'AuthorizedKeysCommandUser'       => 'nobody',
    'ChallengeResponseAuthentication' => 'no',
    'DenyGroups'                      => 'noaccess',
    'GSSAPIAuthentication'            => 'no',
    'HostKey'                         => $host_keys,
    'HostbasedAuthentication'         => 'no',
    'IgnoreRhosts'                    => 'yes',
    'KeyRegenerationInterval'         => '3600',
    'LogLevel'                        => 'INFO',
    'LoginGraceTime'                  => '120',
    'PermitEmptyPasswords'            => 'no',
    'PermitRootLogin'                 => 'no',
    'Port'                            => '22',
    'PrintLastLog'                    => 'yes',
    'PrintMotd'                       => 'no',
    'Protocol'                        => '2',
    'PubkeyAuthentication'            => 'yes',
    'RSAAuthentication'               => 'yes',
    'RhostsRSAAuthentication'         => 'no',
    'ServerKeyBits'                   => '1024',
    'StrictModes'                     => 'yes',
    'Subsystem'                       => "sftp ${sftp_server_bin}",
    'SyslogFacility'                  => 'AUTH',
    'TCPKeepAlive'                    => 'yes',
    'UseDNS'                          => 'no',
    'UsePAM'                          => 'yes',
    'UsePrivilegeSeparation'          => 'yes',
    'X11DisplayOffset'                => '10',
    'X11Forwarding'                   => 'yes',
    'Ciphers'                         => 'aes128-ctr,aes192-ctr,aes256-ctr,aes128-gcm@openssh.com,aes256-gcm@openssh.com,chacha20-poly1305@openssh.com',
    'MACs'                            => 'hmac-sha2-256,hmac-sha2-512,hmac-ripemd160,umac-128@openssh.com,hmac-sha2-256-etm@openssh.com,hmac-sha2-512-etm@openssh.com,hmac-ripemd160-etm@openssh.com,umac-128-etm@openssh.com',
    'KexAlgorithms'                   => 'ecdh-sha2-nistp256,ecdh-sha2-nistp384,ecdh-sha2-nistp521,diffie-hellman-group14-sha1,diffie-hellman-group-exchange-sha1,diffie-hellman-group-exchange-sha256',
  }
}
