# Installs and configures SSH
class twitch_core::authentication::ssh (
  $ensure               = 'present',
  $client_options       = $twitch_core::authentication::params::ssh_options,
  $storeconfigs_enabled = false
) inherits twitch_core::authentication::params {
  validate_string($ensure)
  validate_hash($client_options)
  validate_bool($storeconfigs_enabled)

  class{ '::ssh::client':
    ensure               => $ensure,
    storeconfigs_enabled => $storeconfigs_enabled,
    options              => $client_options
  }
}
