# Installs and configures SSHD
class twitch_core::authentication::sshd (
  $ensure               = $twitch_core::authentication::params::sshd_ensure,
  $server_options       = $twitch_core::authentication::params::sshd_options,
  $storeconfigs_enabled = false
) inherits twitch_core::authentication::params {
  validate_string($ensure)
  validate_hash($server_options)
  validate_bool($storeconfigs_enabled)

  package {'python-ldap':
    ensure => 'present'
  }

  package {'ssh-ldap-pubkey':
    ensure   => '0.4.0',
    provider => 'pip',
    require  => Package['python-ldap'],
  }

  class{ '::ssh::server':
    ensure               => $ensure,
    storeconfigs_enabled => $storeconfigs_enabled,
    options              => $server_options,
    require              => Package['ssh-ldap-pubkey'],
  }
}
