# Controls sudo authorization via /etc/sudoers and /etc/sudoers.d/*
class twitch_core::authentication::sudoers (
  $sudoers_groups = {}
) {
  validate_hash($sudoers_groups)

  $nagios_user = $::osfamily ? {
    'RedHat' => 'nrpe',
    'Debian' => 'nagios',
  }

  sudo::conf { 'ttv-proxy-env':
    priority => 00,
    source   => [
      "puppet:///modules/${module_name}/sudoers/ttv-proxy-env",
      "puppet:///modules/${module_name}/sudoers/null"
    ],
  }

  $host_formatted = regsubst($::fqdn, '\.', '-', 'G')  # used in template
  sudo::conf { 'ttv-team':
    priority => 05,
    content  => template("${module_name}/authentication/sudoers/ttv-team.erb")
  }

  sudo::conf { 'ttv-common':
    priority => 10,
    content  => template("${module_name}/sudoers/ttv-common.erb"),
  }

  sudo::conf { "ttv-${::twitch_role}":
    priority => 20,
    source   => [
      "puppet:///modules/${module_name}/sudoers/twitch_role/${::twitch_role}",
      "puppet:///modules/${module_name}/sudoers/null"
    ],
  }

  sudo::conf { "ttv-${::fqdn}":
    priority => 30,
    source   => [
      "puppet:///modules/${module_name}/sudoers/fqdn/${::fqdn}",
      "puppet:///modules/${module_name}/sudoers/null"
    ],
  }

  if ($::vagrant != undef) {
    sudo::conf { 'vagrant':
      priority => 99,
      content  => template("${module_name}/sudoers/vagrant.erb"),
    }
  }

  # $::aws_bootstrap is defined by "Gold" images for creating EC2 AMIs
  if ($::aws_bootstrap != undef) {
    sudo::conf { 'aws-bootstrap':
      priority => 99,
      content  => 'ubuntu ALL=(ALL) NOPASSWD:ALL'
    }
  }
}
