# Configures UNSCD for LDAP caching
class twitch_core::authentication::unscd {
  if $::osfamily == 'Debian' {
    $service_name = 'unscd'
  } else {
    $service_name = 'nscd'
  }

  file { '/etc/nscd.conf':
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
    source => "puppet:///modules/${module_name}/ldap/nscd.conf",
    notify => Service[$service_name],
  }

  service { $service_name:
    ensure => 'running',
    enable => true,
  }
}
